<?php

class ShowSimilarThreads_Listener
{
	public static function load_class_controller($class, array &$extend)
	{
		if ($class == 'XenForo_ControllerPublic_Forum')
		{
			$extend[] = 'ShowSimilarThreads_ControllerPublic_Forum';
		}
		
		if ($class == 'XenForo_ControllerPublic_Thread')
		{
			$extend[] = 'ShowSimilarThreads_ControllerPublic_Thread';
		}
	}
	
	public static function load_class_datawriter($class, array &$extend)
	{
		if ($class == 'XenForo_DataWriter_Discussion_Thread')
		{
			$extend[] = 'ShowSimilarThreads_DataWriter_Discussion_Thread';
		}
	}
	
	public static function template_create(&$templateName, array &$params, XenForo_Template_Abstract $template)
	{
		if ($templateName == 'thread_view' && XenForo_Application::get('options')->showSimilarThreadsInThreads)
		{
			$template->preloadTemplate('similar_threads');
		}
	}
	
	public static function template_hook($hookName, &$contents, array $hookParams, XenForo_Template_Abstract $template)
	{
		switch ($hookName)
		{
			case 'thread_create':
				if (XenForo_Application::get('options')->showSimilarThreadsOnThreadCreation)
				{
					$contents .= $template->create('similar_threads_thread_create', $template->getParams());
				}
				break;
			
			case 'thread_create_fields_main':
				if (XenForo_Application::get('options')->showSimilarThreadsOnThreadCreation)
				{
					$contents .= '<div id="SimilarThreads" style="width: 92%; margin: 0 auto;"></div>';
				}
				break;
			
			case 'thread_view_qr_after':
				if (XenForo_Application::get('options')->showSimilarThreadsInThreads)
				{
					$contents .= $template->create('similar_threads', $template->getParams());
				}
				break;
		}
	}
}

?>